/****
 * vB Forum Titles AJAX Editor
 * Copyright 2008; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

function _vB_AJAX_Forumlist()
{
	this.compat = AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2);
	this.spans = new Array();

	this.init = function()
	{
		if (this.compat)
		{
			var spans = fetch_tags(document.body, 'span');

			for (var s = 0; s < spans.length; s++)
			{
				if (spans[s].id && spans[s].id.substr(0, 16) == 'forumtitle_ajax_')
				{
					this.spans[spans[s].id.replace('forumtitle_ajax_', '')] = spans[s];
					this.seek_parent(spans[s], 'td').ondblclick = vB_AJAX_Forumlist.forum_doubleclick;
				}
			}
		}
	}

	this.seek_parent = function(obj, parent)
	{
		while (obj.parentNode && obj.parentNode.tagName.toLowerCase() != parent)
		{
			obj = obj.parentNode;
		}

		return obj.parentNode;
	}

	this.seek_link = function(obj, match, what)
	{
		links = fetch_tags(obj, 'a');

		for (var a = 0; a < links.length; a++)
		{
			if (links[a].href && links[a].href.match(match))
			{
				switch (what)
				{
					case 'id':
					{
						return RegExp.$1;
					}
					break;

					case 'link':
					{
						// returning links[a] can lead to just reference to href, instead of object, strange...
						links[a].id = 'forumlink_' + RegExp.$1;

						return fetch_object(links[a].id);
					}
					break;
				}
			}
		}
	}

	this.make_element = function(element, attributes)
	{
		element = document.createElement(element);

		for (a in attributes)
		{
			eval("element." + a + " = " + ((parseInt(attributes[a])  == attributes[a]) ? attributes[a] : "'" + attributes[a] + "'") + ";");
		}

		return element;
	}

	this.forum_doubleclick = function(e)
	{
		vB_ForumTitle_Editor = new vB_AJAX_Forum_TitleEdit(this);
		vB_ForumTitle_Editor.open_editor();
	}

	this.input_blur = function(e)
	{
		vB_ForumTitle_Editor.close_editor(false);
	}

	this.input_onkeypress = function(e)
	{
		e = e ? e : window.event;

		switch (e.keyCode)
		{
			case 13:
			{
				vB_ForumTitle_Editor.close_editor(false);

				return true;
			}

			case 27:
			{
				vB_ForumTitle_Editor.close_editor(true);

				return true;
			}
		}
	}
}

function vB_AJAX_Forum_TitleEdit(obj)
{
	this.obj = obj;
	this.linkobj = vB_AJAX_Forumlist.seek_link(obj, /f=(\d+)/, 'link');
	this.forumid = vB_AJAX_Forumlist.seek_link(obj, /f=(\d+)/, 'id');
	this.span = vB_AJAX_Forumlist.spans[this.forumid];

	this.editing = false;
	this.title = '';

	this.progress_image = new Image();
	this.progress_image.src = IMGDIR_MISC + "/11x11progress.gif";

	this.open_editor = function()
	{
		if (this.editing)
		{
			return false;
		}

		this.title = PHP.trim(PHP.unhtmlspecialchars(this.span.innerHTML));

		this.input = vB_AJAX_Forumlist.make_element('input', {
			'type'		: 'text',
			'size'		: 99,
			'className'	: 'bginput',
			'style.width'	: Math.max(this.linkobj.offsetWidth, 250) + 'px',
			'value'		: this.title
		});

		this.input.onblur = vB_AJAX_Forumlist.input_blur;
		this.input.onkeypress = vB_AJAX_Forumlist.input_onkeypress;

		this.editor = this.linkobj.parentNode.insertBefore(this.input, this.linkobj);
		this.editor.select();

		this.linkobj.style.display = 'none';

		this.editing = true;
	}

	this.close_editor = function(cancel)
	{
		if (!this.editing)
		{
			return false;
		}

		if (cancel)
		{
			this.editor.value = this.title;
		}

		this.editor.value = PHP.trim(this.editor.value);

		if (this.editor.value != this.title)
		{
			this.linkobj.parentNode.appendChild(this.progress_image);
			this.save(this.editor.value);
		}

		this.editor.parentNode.removeChild(this.editor);
		this.linkobj.style.display = '';

		this.editing = false;
	}

	this.save = function(forumtitle)
	{
		YAHOO.util.Connect.asyncRequest("POST", "ajax.php?do=updateforumtitle&f=" + this.forumid, {
			success: this.saved,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=updateforumtitle&f=" + this.forumid + '&title=' + PHP.urlencode(forumtitle));
	}

	this.saved = function(ajax)
	{
		if (ajax.responseXML)
		{
			if (ajax.responseXML.getElementsByTagName('forumtitle') &&  ajax.responseXML.getElementsByTagName('forumtitle')[0])
			{
				this.span.innerHTML = ajax.responseXML.getElementsByTagName('forumtitle')[0].firstChild.nodeValue;
			}
		}

		this.linkobj.parentNode.removeChild(this.progress_image);
	}
}

vB_AJAX_Forumlist = new _vB_AJAX_Forumlist();
vB_AJAX_Forumlist.init();